package messages

import "code.justin.tv/gds/gds/golibs/event"

// set up message factory for this package - declare a variable at top scope
// to import serialization of all message types..
func BuildFactory() *event.MessageFactory {
	f := event.NewMessageFactory()
	RegisterWithFactory(f)
	return f
}

func SupportedVersions(topic event.Topic) []int {
	switch topic {
	case ConfigTopic:
		return []int{1}
	}
	return []int{}
}

// Append these messages to an existing factory
func RegisterWithFactory(f *event.MessageFactory) {
	f.Register(ConfigTopic, OnSet, SupportedVersions(ConfigTopic), LoadConfigMessage)
}
