package protocol

import (
	"encoding/json"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestRecord(t *testing.T) {
	content := "value"
	t.Run("values are forwarded correctly", func(t *testing.T) {
		rec := NewRecord("2", &content)
		assert.Equal(t, "2", rec.Version())
		assert.Equal(t, "value", *rec.Content())

		rec2 := *rec
		assert.Equal(t, "2", rec2.Version())
		assert.Equal(t, "value", *rec2.Content())
	})

	t.Run("values are marshaled correctly", func(t *testing.T) {
		rec := NewRecord("2", &content)
		data, err := json.Marshal(rec)
		assert.NotEmpty(t, data)
		assert.NoError(t, err)

		var rec2 Record
		assert.NoError(t, rec2.UnmarshalJSON(data))
		assert.Equal(t, "2", rec2.Version())
		assert.Equal(t, "value", *rec2.Content())
	})

	t.Run("invalid values report errors correctly", func(t *testing.T) {
		var rec Record
		assert.IsType(t, &json.SyntaxError{}, rec.UnmarshalJSON([]byte("{")))
	})
}
