package api

import (
	"code.justin.tv/extensions/fulton-configuration/auth"
	"code.justin.tv/extensions/fulton-configuration/data"
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"context"

	"code.justin.tv/gds/gds/golibs/params"
)

func (a *API) DeleteConfiguration(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	cid := p.Get("cid")
	reporter := telemetry.SampleReporterWithContext(a.Reporter, ctx)

	creds := auth.Load(ctx)
	if barbradyCreds, ok := creds.(*auth.BarbradyCredentials); ok {
		barbradyCreds.RequestCapabilities(
			[]string{auth.CapEditBroadcasterConfig},
			map[string]string{
				auth.ParamChannelID: cid,
			},
		)
	}

	err := data.Load(ctx).DeleteByChannel(cid)
	convertAndReportResponse(ctx, "delete_configuration", err, reporter)
	return nil, err
}
