package api

import (
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"code.justin.tv/extensions/fulton-configuration/auth"
	"code.justin.tv/extensions/fulton-configuration/data"
	"code.justin.tv/extensions/fulton-configuration/protocol"
	"code.justin.tv/gds/gds/golibs/params"
	"context"
)

func (a *API) DeleteConfigurationV2(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	cid := p.Get("cid")
	reporter := telemetry.SampleReporterWithContext(a.Reporter, ctx)

	var deleteConfigurationV2Body protocol.EditConfigurationV2Input
	if err := p.ParseJSONBody(&deleteConfigurationV2Body); err != nil {
		convertAndReportResponse(ctx, "delete_configuration_v2", err, reporter)
		return nil, protocol.ErrMissingBody
	}

	barbradyParams := map[string]string{auth.ParamChannelID: cid}
	if deleteConfigurationV2Body.ExtJwt != "" {
		barbradyParams[auth.ParamJWT] = deleteConfigurationV2Body.ExtJwt
		if deleteConfigurationV2Body.ClientId == "" {
			convertAndReportResponse(ctx, "delete_configuration_v2", protocol.ErrMissingClientID, reporter)
			return nil, protocol.ErrMissingClientID
		}
		barbradyParams[auth.ParamClientID] = deleteConfigurationV2Body.ClientId
	}

	if deleteConfigurationV2Body.UserID != "" {
		barbradyParams[auth.ParamUserID] = deleteConfigurationV2Body.UserID
	}

	creds := auth.Load(ctx)
	if barbradyCreds, ok := creds.(*auth.BarbradyCredentials); ok {
		barbradyCreds.RequestCapabilities(
			[]string{auth.CapEditBroadcasterConfig},
			barbradyParams,
		)
	}

	err := data.Load(ctx).DeleteByChannel(cid)
	convertAndReportResponse(ctx, "delete_configuration_v2", err, reporter)
	return nil, err
}
