package api

import (
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"context"
	"strconv"
	"strings"

	"code.justin.tv/extensions/fulton-configuration/data"
	"code.justin.tv/extensions/fulton-configuration/protocol"
	"code.justin.tv/gds/gds/golibs/params"
)

func (a *API) GetChannelConfiguration(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	ext := strings.Split(p.Get("ext_ids"), ",")
	reporter := telemetry.SampleReporterWithContext(a.Reporter, ctx)
	for i, s := range ext {
		ext[i] = strings.TrimSpace(s)
	}
	common := p.Get("common")
	includeCommon := true
	if common != "" {
		var err error
		includeCommon, err = strconv.ParseBool(common)
		if err != nil {
			convertAndReportResponse(ctx, "get_channel_configuration",  protocol.ErrInvalidCommonParameter, reporter)
			return nil, protocol.ErrInvalidCommonParameter
		}
	}

	ret, err := data.Load(ctx).GetByChannel(p.Get("cid"), includeCommon, ext...)
	convertAndReportResponse(ctx, "get_channel_configuration", err, reporter)
	return ret, err
}
