package api

import (
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"context"

	"code.justin.tv/extensions/fulton-configuration/data"
	"code.justin.tv/extensions/fulton-configuration/protocol"
	"code.justin.tv/gds/gds/golibs/params"
)

func (a *API) GetConfiguration(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	reporter := telemetry.SampleReporterWithContext(a.Reporter, ctx)

	var addr []protocol.Address
	if err := p.ParseJSONBody(&addr); err != nil {
		convertAndReportResponse(ctx, "get_configuration", err, reporter)
		return nil, err
	}

	ret, err := data.Load(ctx).Get(addr...)
	convertAndReportResponse(ctx, "get_configuration", err, reporter)
	return ret, err
}
