package api

import (
	"code.justin.tv/extensions/fulton-configuration/auth"
	"code.justin.tv/extensions/fulton-configuration/data"
	"code.justin.tv/extensions/fulton-configuration/protocol"
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"code.justin.tv/gds/gds/golibs/params"
	"context"
)

func (a *API) SetChannelConfiguration(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	reporter := telemetry.SampleReporterWithContext(a.Reporter, ctx)

	var in protocol.SetChannelConfigurationInput
	if err := p.ParseJSONBody(&in); err != nil {
		convertAndReportResponse(ctx, "set_channel_configuration", err, reporter)
		return nil, err
	}

	creds := auth.Load(ctx)

	ext, err := data.Load(ctx).ForExtension(in.ExtensionID)
	if err != nil {
		convertAndReportResponse(ctx, "set_channel_configuration", err, reporter)
		return nil, err
	}
	if in.Developer != nil {
		seg, err := protocol.Developer(in.ChannelID)
		if err != nil {
			convertAndReportResponse(ctx, "set_channel_configuration", err, reporter)
			return nil, err
		}

		if barbradyCreds, ok := creds.(*auth.BarbradyCredentials); ok {
			barbradyCreds.RequestCapabilities(
				[]string{auth.CapEditDeveloperConfig},
				map[string]string{
					auth.ParamExtensionID: in.ExtensionID,
				},
			)
		}
		ext.Set(seg, in.Developer)
	}
	if in.Broadcaster != nil {
		seg, err := protocol.Broadcaster(in.ChannelID)
		if err != nil {
			convertAndReportResponse(ctx, "set_channel_configuration", err, reporter)
			return nil, err
		}

		if barbradyCreds, ok := creds.(*auth.BarbradyCredentials); ok {
			barbradyCreds.RequestCapabilities(
				[]string{auth.CapEditBroadcasterConfig},
				map[string]string{
					auth.ParamChannelID: in.ChannelID,
				},
			)
		}
		ext.Set(seg, in.Broadcaster)
	}

	err = ext.Save()
	convertAndReportResponse(ctx, "set_channel_configuration", err, reporter)
	return nil, err
}
