package api

import (
	"code.justin.tv/extensions/fulton-configuration/auth"
	"code.justin.tv/extensions/fulton-configuration/data"
	"code.justin.tv/extensions/fulton-configuration/protocol"
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"code.justin.tv/gds/gds/golibs/params"
	"context"
)

func (a *API) SetConfiguration(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	reporter := telemetry.SampleReporterWithContext(a.Reporter, ctx)

	var in protocol.SetConfigurationInput
	if err := p.ParseJSONBody(&in); err != nil {
		convertAndReportResponse(ctx, "set_configuration", err, reporter)
		return nil, err
	}
	seg, err := in.Address.Segment()
	if err != nil {
		convertAndReportResponse(ctx, "set_configuration", err, reporter)
		return nil, err
	}
	ext, err := data.Load(ctx).ForExtension(in.Address.ExtensionID)
	if err != nil {
		convertAndReportResponse(ctx, "set_configuration", err, reporter)
		return nil, err
	}

	record := in.Record
	if record == nil {
		record = protocol.NewRecord("", nil)
	}

	creds := auth.Load(ctx)
	if barbradyCreds, ok := creds.(*auth.BarbradyCredentials); ok {
		barbradyCreds.RequestCapabilities(
			[]string{auth.CapEditDeveloperConfig, auth.CapEditBroadcasterConfig},
			map[string]string{
				auth.ParamExtensionID: in.Address.ExtensionID,
				auth.ParamChannelID:   seg.ChannelID(),
			},
		)
	}

	err = ext.Set(seg, record).Save()
	convertAndReportResponse(ctx, "set_configuration", err, reporter)
	return nil, err
}
