package api

import (
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"code.justin.tv/extensions/fulton-configuration/auth"
	"context"

	"code.justin.tv/extensions/fulton-configuration/data"
	"code.justin.tv/extensions/fulton-configuration/protocol"
	"code.justin.tv/gds/gds/golibs/params"
)

func (a *API) SetConfigurationV2(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	reporter := telemetry.SampleReporterWithContext(a.Reporter, ctx)

	var in protocol.SetConfigurationInputV2
	if err := p.ParseJSONBody(&in); err != nil {
		convertAndReportResponse(ctx, "set_configuration_v2", err, reporter)
		return nil, err
	}
	seg, err := in.Address.Segment()
	if err != nil {
		convertAndReportResponse(ctx, "set_configuration_v2", err, reporter)
		return nil, err
	}
	ext, err := data.Load(ctx).ForExtension(in.Address.ExtensionID)
	if err != nil {
		convertAndReportResponse(ctx, "set_configuration_v2", err, reporter)
		return nil, err
	}
	record := in.Record
	if record == nil {
		record = protocol.NewRecord("", nil)
	}

	barbradyParams := map[string]string{
		auth.ParamExtensionID: in.Address.ExtensionID,
		auth.ParamChannelID:   seg.ChannelID(),
	}

	if in.ExtJwt != "" {
		barbradyParams[auth.ParamJWT] = in.ExtJwt
		if in.ClientId == "" {
			convertAndReportResponse(ctx, "set_configuration_v2", protocol.ErrMissingClientID, reporter)
			return nil, protocol.ErrMissingClientID
		}
		barbradyParams[auth.ParamClientID] = in.ClientId
	}

	if in.UserID != "" {
		barbradyParams[auth.ParamUserID] = in.UserID
	}

	creds := auth.Load(ctx)
	if barbradyCreds, ok := creds.(*auth.BarbradyCredentials); ok {
		barbradyCreds.RequestCapabilities(
			[]string{auth.CapEditDeveloperConfig, auth.CapEditBroadcasterConfig},
			barbradyParams,
		)
	}

	err = ext.Set(seg, record).Save()
	convertAndReportResponse(ctx, "set_configuration_v2", err, reporter)
	return nil, err

}
