package cloudwatch

import (
	"context"
	"time"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"code.justin.tv/extensions/instrumentation"
)

type cloudwatchWrapper struct {
}

var _ instrumentation.ContextInstrumenter = (*cloudwatchWrapper)(nil)

func NewCloudwatchInstrumenter() *cloudwatchWrapper {
	return &cloudwatchWrapper{}
}

var _ instrumentation.ContextInstrumenter = (*cloudwatchWrapper)(nil)

func (s *cloudwatchWrapper) Instrument(ctx context.Context, name string, status int, callTime time.Duration, rate float32) {
	cw := LoadCloudwatch(ctx)
	cw.OperationName = name

	cw.ReportDurationSample(telemetry.MetricDuration, callTime)
	cw.ReportAvailabilitySamples(statusCodeToAvailabilityCode(status))
}

func statusCodeToAvailabilityCode(status int) telemetry.AvailabilityCode {
	switch {
	case status >= 200 && status < 400:
		return telemetry.AvailabilityCodeSucccess
	case status >= 400 && status < 500:
		return telemetry.AvailabilityCodeClientError
	case status >= 500:
		return telemetry.AvailabilityCodeServerError
	default:
		return telemetry.AvailabilityCodeServerError
	}
}
