package cloudwatch

import (
	"context"
	"net/http"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
)

var (
	// actual key is the address of this var, which is unique in program space
	cloudwatchValue = -42
	cloudwatchKey   = &cloudwatchValue
)

// Store a twitchtelemetry SampleReporter on the context
func Store(sampleReporter telemetry.SampleReporter) func(http.Handler) http.Handler {
	return func(inner http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			ctx := store(r.Context(), sampleReporter)
			inner.ServeHTTP(w, r.WithContext(ctx))
		})
	}
}

func store(ctx context.Context, cw telemetry.SampleReporter) context.Context {
	return context.WithValue(ctx, cloudwatchKey, cw)
}

// LoadCloudwatch pulls a sampleReporter out of the context
func LoadCloudwatch(ctx context.Context) telemetry.SampleReporter {
	if cw, ok := ctx.Value(cloudwatchKey).(telemetry.SampleReporter); ok {
		return cw
	}
	cw := *telemetry.NewNoOpSampleReporter()
	return cw
}
