package datadog

import (
	"context"
	"fmt"
	"time"

	"code.justin.tv/extensions/instrumentation"
)

type datadogdWrapper struct {
}

var _ instrumentation.ContextInstrumenter = (*datadogdWrapper)(nil)

func NewDatadogInstrumenter() *datadogdWrapper {
	return &datadogdWrapper{}
}

const response string = "response"
const timing string = "response.timing"

func (s *datadogdWrapper) Instrument(ctx context.Context, name string, status int, callTime time.Duration, rate float32) {
	rate64 := float64(rate)
	datadog := LoadDatadog(ctx)

	tags := []string{fmt.Sprintf("Name:%s", name), fmt.Sprintf("Status:%d", status)}

	_ = datadog.Incr(response, tags, rate64)

	_ = datadog.Timing(timing, callTime, tags, rate64) //add status

}
