package datadog

import (
	"context"
	"net/http"

	"github.com/DataDog/datadog-go/statsd"
)

var (
	// actual key is the address of this var, which is unique in program space
	datadogValue = -42
	datadogKey   = &datadogValue
)

// StoreDatadog stores a Client in the context
func StoreDatadog(stats *statsd.Client) func(http.Handler) http.Handler {
	return func(inner http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			ctx := store(r.Context(), stats)
			inner.ServeHTTP(w, r.WithContext(ctx))
		})
	}
}

func store(ctx context.Context, stats *statsd.Client) context.Context {
	return context.WithValue(ctx, datadogKey, stats)
}

// StoreDatadog pulls a Client out of the context
func LoadDatadog(ctx context.Context) *statsd.Client {
	if stats, ok := ctx.Value(datadogKey).(*statsd.Client); ok {
		return stats
	}
	c, _ := statsd.New("")
	return c // Need to figure out appropriate noop

}
