package logging

import (
	"context"
	"net/http"

	"go.uber.org/zap"
)

var (
	// actual key is the address of this var, which is unique in program space
	logStoreValue = -42
	logStoreKey   = &logStoreValue
)

type logStore struct {
	logs []zap.Field
}

// StoreDatadog stores a Client in the context
func (ls *logStore) Log(key string, value string) {
	ls.logs = append(ls.logs, zap.String(key, value))
}

func Store() func(http.Handler) http.Handler {
	return func(inner http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			m := []zap.Field{}
			ls := logStore{m}
			ctx := store(r.Context(), &ls)
			inner.ServeHTTP(w, r.WithContext(ctx))
		})
	}
}

func store(ctx context.Context, logger *logStore) context.Context {
	return context.WithValue(ctx, logStoreKey, logger)
}

// Load pulls a logs out of context
func Load(ctx context.Context) *logStore {
	if ls, ok := ctx.Value(logStoreKey).(*logStore); ok {
		return ls
	}
	return &logStore{}
}
