package logging

import (
	"context"
	"time"

	"code.justin.tv/extensions/instrumentation"
	"go.uber.org/zap"
)

type loggingWrapper struct {
}

func NewLoggingInstrumenter() *loggingWrapper {
	return &loggingWrapper{}
}

var _ instrumentation.ContextInstrumenter = (*loggingWrapper)(nil)

func (s *loggingWrapper) Instrument(ctx context.Context, name string, status int, callTime time.Duration, rate float32) {
	ls := Load(ctx)
	logger := LoadLogger(ctx)
	logger.With(zap.Int("response_status", status), zap.String("request_name", name), zap.Duration("request_duration", callTime)).Info("request log", ls.logs...)

}
