package statsd

import (
	"context"
	"net/http"

	"github.com/cactus/go-statsd-client/statsd"
)

var (
	// actual key is the address of this var, which is unique in program space
	statsdValue = -42
	statsdKey   = &statsdValue
)

// StoreStatsd stores a Statter in the context
func Store(stats statsd.Statter) func(http.Handler) http.Handler {
	return func(inner http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			ctx := store(r.Context(), stats)
			inner.ServeHTTP(w, r.WithContext(ctx))
		})
	}
}

func store(ctx context.Context, stats statsd.Statter) context.Context {
	return context.WithValue(ctx, statsdKey, stats)
}

// LoadStatsd pulls a Statter out of the context
func LoadStatsd(ctx context.Context) statsd.Statter {
	if stats, ok := ctx.Value(statsdKey).(statsd.Statter); ok {
		return stats
	}
	stats, _ := statsd.NewNoop()
	return stats
}
