package statsd

import (
	"context"
	"fmt"
	"time"

	"code.justin.tv/extensions/instrumentation"
)

type statsdWrapper struct {
}

var _ instrumentation.ContextInstrumenter = (*statsdWrapper)(nil)

func NewStatsDInstrumenter() *statsdWrapper {
	return &statsdWrapper{}
}

var _ instrumentation.ContextInstrumenter = (*statsdWrapper)(nil)

func (s *statsdWrapper) Instrument(ctx context.Context, name string, status int, callTime time.Duration, rate float32) {
	stats := LoadStatsd(ctx)
	statLine := fmt.Sprintf("%s.status.%d", name, status)
	_ = stats.Inc(statLine, 1, rate)

	timeLine := fmt.Sprintf("%s.timing", name)
	_ = stats.TimingDuration(timeLine, callTime, rate)

	statTimeLine := fmt.Sprintf("%s.%d", timeLine, status)
	_ = stats.TimingDuration(statTimeLine, callTime, rate)
}
