package instrumentation

import (
	"net/http"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestStatusWriter(t *testing.T) {
	inner := &nullWriter{}
	w := &statusWriter{inner: inner}
	assert.Empty(t, w.Header())

	count, err := w.Write([]byte("abc"))
	assert.Equal(t, 3, count)
	assert.NoError(t, err)
	assert.Equal(t, http.StatusOK, w.status) // see definition of http.ResponseWriter

	w = &statusWriter{inner: inner}
	w.WriteHeader(http.StatusConflict)
	assert.Equal(t, http.StatusConflict, w.status)
}
