# Twitch Extensions Kubernetes Fabric

## Cluster Names
Our Kubernetes fabric consists of many cluster in many accounts spread across regions and Availability Zones. This architecture keeps in line with the _Tiny Bubble_ or _Nebula_ concept followed by Amazon.
### Hydra
**AWS ACCOUNT**: `twitch-extensions-k8s-us-west-2`

The `hydra` cluster owns and runs the federation control plane for all Extensions clusters
### Smart
**AWS ACCOUNT**: `twitch-extensions-smart-dev`

The `smart` cluster is responsible for running the S.M.A.R.T service

## DNS Structuring
**AWS ACCOUNT**: `twitch-extensions-a2z@amazon.com`
### Existing Names
```$xslt
extensions.twitch.a2z.com
├──hydra.
│   └──us─west─2.
│       ├──api.
│       │   └──internal.
│       ├──bastion.
│       └──internal.
│           ├──etcd-a.
│           ├──etcd-b.
│           ├──etcd-c.
│           ├──etcd-events-a.
│           ├──etcd-events-b.
│           └──etcd-events-c.
└──smart.
    └──us─west─2.
        ├──api.
        │   └──internal.
        └──bastion.
```
### Naming Conventions
```$xslt
extensions.twitch.a2z.com
└──<CLUSTER_NAME>.
    └──<AWS_REGION>.
        ├──api.                     <--External API Endpoint into Kubernetes Cluster
        │   └──internal.            <--Internal API Endpoint into Kubernetes Cluster
        ├──bastion.                 <--DMZ Auth'd SSH Bastion for SSH'ing into internal IP'd k8s nodes
        └──internal.
            ├──<RESOURCE_NAME>.     <--These are reachable only from within the VPC/Cluster's private zone
            ...
```