/*
Blanks in this file are replaced when cluster is initialized using init.py
*/

provider "aws" {
  region = "us-west-2"
  version = "~> 1.17"
  allowed_account_ids = [""]
}

module "base_vpc" {
  source = "../modules/base_vpc"

  cluster_name = ""
  cluster_domain = ""
  cluster_region = ""
  cluster_azs = [""]
  environment_name = ""

  vpc_cidr = "10.0.0.0/16"
  private_subnets = ["10.0.64.0/20","10.0.80.0/20","10.0.96.0/20"]
  public_subnets = ["10.0.128.0/20","10.0.144.0/20","10.0.160.0/20"]
}

module "eks_cluster" {
  source  = "../modules/eks_cluster"

  cluster_name          = "${module.base_vpc.eks_cluster_name}"
  private_subnets       = ["${module.base_vpc.private_subnet_ids}"]
  tags                  = {
                          Environment = "${module.base_vpc.environment}"
                          datadog  = "true"
                        }
  vpc_id                = "${module.base_vpc.vpc_id}"
  worker_instance_type  = "c5.large"
  key_name = ""
//  map_roles = [
//    {
//      role_arn = "arn:aws:iam::<ACCOUNT_ID>:role/kubectl"
//      username = "kubectl"
//      group    = "system:masters"
//    },
//  ]
}
//
//module "datadog_integration" {
//  source = "../modules/datadog_integration"
//  external_id = "<ACCOUNT_EXT_ID_FROM_DD>"
//}
//
//module "ecs_registry" {
//  source = "../modules/ecs_registry"
//  repo_name = "twitch-extensions-<SERVICE_NAME>>/main"
//}
