terraform {
  required_version = ">= 0.11.8"
}

provider "random" {
  version = "= 1.3.1"
}

resource "random_string" "suffix" {
  length  = 8
  special = false
}

locals {
  eks_cluster_name = "${var.cluster_name}-${random_string.suffix.result}"
}

module "vpc" {
  source  = "terraform-aws-modules/vpc/aws"
  version = "1.31.0"

  name    = "${var.cluster_name}"
  cidr    = "${var.vpc_cidr}"

  azs     = "${var.cluster_azs}"
  public_subnets  = "${var.public_subnets}"
  private_subnets = "${var.private_subnets}"

  private_subnet_tags = {
    "kubernetes.io/role/internal-elb" = "1"
  }
  public_subnet_tags = {
    "kubernetes.io/role/elb" = "1"
  }

  enable_dns_hostnames  = true
  enable_nat_gateway    = true
  propagate_private_route_tables_vgw = true
  propagate_public_route_tables_vgw = true

  tags = {
    Environment = "${var.environment_name}"
    Name        = "${var.cluster_name}"
    Terraform   = "True"
    datadog     = "true"
    "kubernetes.io/cluster/${local.eks_cluster_name}" = "shared"
  }
}
