# VPC
output "vpc_id" {
  description = "The ID of the VPC"
  value       = "${module.vpc.vpc_id}"
}

# Addressing
output "cidr_block" {
  value = "${var.vpc_cidr}"
}

output "private_subnet_ids" {
  value = "${module.vpc.private_subnets}"
}

output "public_subnet_ids" {
  value = "${module.vpc.public_subnets}"
}

output "private_subnet_cidrs" {
  value = "${module.vpc.private_subnets_cidr_blocks}"
}

output "public_subnet_cidrs" {
  value = "${module.vpc.public_subnets_cidr_blocks}"
}

# Regionality
output "availability_zones" {
  value = "${var.cluster_azs}"
}

output "region" {
  value = "${var.cluster_region}"
}

output "cluster_name" {
  value = "${var.cluster_name}"
}

output "cluster_domain" {
  value = "${var.cluster_domain}"
}

output "environment" {
  value = "${var.environment_name}"
}

output "eks_cluster_name" {
  value = "${local.eks_cluster_name}"
}
