variable "cluster_region" {
  description = "Region to deploy this cluster"
  type = "string"
}

variable "cluster_azs" {
  description = "Availability Zones to deploy resources across. Must be an ODD NUMBER for k8s!"
  type = "list"
}

variable "cluster_name" {
  description = "Name for this cluster. Ex: west-coast"
  type = "string"
}

variable "cluster_domain" {
  description = "Route53 zone for this cluster"
  type = "string"
}

variable "vpc_cidr" {
  description = "Master CIDR for the entire cluster/VPC"
  type = "string"
}

variable "public_subnets" {
  description = "Subnets for Public Exposed Resources"
  type = "list"
}

variable "private_subnets" {
  description = "Subnets for Private Resources"
  type = "list"
}

variable "environment_name" {
  description = "Name for the environment/stage. Ex: dev|staging|prod"
  type = "string"
}
