resource "aws_iam_role" "DatadogAWSIntegrationRole" {
  name = "DatadogAWSIntegrationRole"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": {
    "Effect": "Allow",
    "Principal": {"AWS": "arn:aws:iam::464622532012:root"},
    "Condition": {"StringEquals": {"sts:ExternalId": "${var.external_id}"}},
    "Action": "sts:AssumeRole"
  }
}
  EOF
}

resource "aws_iam_policy" "DatadogAWSIntegrationPolicy" {
  name = "DatadogAWSIntegrationPolicy"
  description = "Policy to allow DataDog to pull metrics and information"
  policy = "${file("../modules/datadog_integration/DatadogAWSIntegrationPolicy.json")}"
}

resource "aws_iam_role_policy_attachment" "DatadogAWSIntegrationPolicyRoleAttachment" {
  policy_arn = "${aws_iam_policy.DatadogAWSIntegrationPolicy.arn}"
  role = "${aws_iam_role.DatadogAWSIntegrationRole.name}"
}
