terraform {
  required_version = ">= 0.11.8"
}

provider "random" {
  version = "= 1.3.1"
}

locals {
  worker_groups = [
    {
      asg_desired_capacity = 3
      asg_max_size = 6
      asg_min_size = 3
      instance_type = "${var.worker_instance_type}"
      name = "worker_nodes_group_a"
      subnets = "${join(",",var.private_subnets)}"
      key_name = "${var.key_name}"
      autoscaling_enabled = true
    }
  ]
}

module "eks" {
  source                                = "terraform-aws-modules/eks/aws"
  version                               = "1.6.0"
  cluster_name                          = "${var.cluster_name}"
  subnets                               = ["${var.private_subnets}"]
  tags                                  = "${var.tags}"
  vpc_id                                = "${var.vpc_id}"
  cluster_version                       = "1.10"
  worker_groups                         = "${local.worker_groups}"
  worker_group_count                    = "1"
  map_roles                             = "${var.map_roles}"
  create_elb_service_linked_role        = true
}
