variable "region" {
  default = "us-west-2"
}

variable "cluster_name" {
  description = "Name of EKS Cluster"
  type        = "string"
}

variable "private_subnets" {
  description = "List of Private Subnets to Launch Cluster In"
  type        = "list"
}

variable "tags" {
  description = "Map of tags to apply to eks cluster"
  type        = "map"
}

variable "vpc_id" {
  description = "VPC to launch cluster and nodes in"
  type        = "string"
}

variable "key_name" {
  description = "SSH Key to use for instances"
  type        = "string"
}

variable "worker_instance_type" {
  description = "AWS Instance"
  type        = "string"
  default     = "m4.xlarge"
}

variable "map_roles" {
  description = "Additional IAM roles to add to the aws-auth configmap."
  type        = "list"

  default = []
}

//variable "map_accounts" {
//  description = "Additional AWS account numbers to add to the aws-auth configmap."
//  type        = "list"
//
//  default = [
//    "777777777777",
//    "888888888888",
//  ]
//}
//
//variable "map_users" {
//  description = "Additional IAM users to add to the aws-auth configmap."
//  type        = "list"
//
//  default = [
//    {
//      user_arn = "arn:aws:iam::66666666666:user/user1"
//      username = "user1"
//      group    = "system:masters"
//    },
//    {
//      user_arn = "arn:aws:iam::66666666666:user/user2"
//      username = "user2"
//      group    = "system:masters"
//    },
//  ]
//}