package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/protocol/response"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/extensions/orchestration/service/protocol/request"
	emsdocs "code.justin.tv/gds/gds/extensions/ems/documents"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// ActivateExtensions - activate extensions in bulk
func ActivateExtensions(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	var body request.ActivationConfigurationParams
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	cid := p.Get("cid")

	emsClient := ems.RetrieveClient(ctx)

	params := emsdocs.ActivationConfigurationParams{}
	for _, param := range body.Activations {
		params.Activations = append(params.Activations, emsdocs.ActivationConfigurationParam{
			ID:      param.ID,
			Version: param.Version,
			Anchor:  protocol.ToEMSAnyAnchorParam(param.Anchor),
		})
	}

	resp, err := emsClient.ActivateExtensions(ctx, cid, params, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	doc := response.ActivationsDocument{
		InstalledExtensions: []*response.InstalledExtensionDocument{},
	}

	for _, installation := range resp.InstalledExtensions {
		doc.InstalledExtensions = append(doc.InstalledExtensions, protocol.FromEMSInstalledExtensionDocument(installation))
	}

	return doc, nil
}
