package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol/request"
	"code.justin.tv/foundation/twitchclient"
	emsdocs "code.justin.tv/gds/gds/extensions/ems/documents"
	emsprotocol "code.justin.tv/gds/gds/extensions/ems/protocol"
	"code.justin.tv/gds/gds/golibs/params"
)

// AddExtension - create or update an extension version
func AddExtension(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	var body request.Manifest
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	emsClient := ems.RetrieveClient(ctx)

	manifest := emsdocs.Manifest{
		AssetHash:                    body.AssetHash,
		AssetPaths:                   body.AssetPaths,
		AuthorEmail:                  body.AuthorEmail,
		AuthorName:                   body.AuthorName,
		BitsEnabled:                  body.BitsEnabled,
		BitsSupportLevel:             emsprotocol.BitsSupportLevel(body.BitsSupportLevel),
		BroadcasterWhitelist:         body.BroadcasterWhitelist,
		Categories:                   body.Categories,
		ConfigurationLocation:        body.ConfigurationLocation,
		Description:                  body.Description,
		EULATOSURL:                   body.EULATOSURL,
		ExtensionID:                  body.ExtensionID,
		Games:                        body.Games,
		HasChatSupport:               body.HasChatSupport,
		IconPath:                     body.IconPath,
		IconURL:                      body.IconURL,
		Name:                         body.Name,
		PrivacyPolicyURL:             body.PrivacyPolicyURL,
		RequestIdentityLink:          body.RequestIdentityLink,
		RequiredBroadcasterAbilities: body.RequiredBroadcasterAbilities,
		RequiredConfigurationString:  body.RequiredConfigurationString,
		ScreenshotPaths:              body.ScreenshotPaths,
		ScreenshotURLs:               body.ScreenshotURLs,
		SKU:                          body.SKU,
		SubscriptionsSupportLevel:    emsprotocol.SubscriptionsSupportLevel(body.SubscriptionsSupportLevel),
		Summary:                      body.Summary,
		SupportEmail:                 body.SupportEmail,
		TestingAccounts:              body.TestingAccounts,
		TestingBaseURI:               body.TestingBaseURI,
		VendorCode:                   body.VendorCode,
		Version:                      body.Version,
		WhitelistedConfigURLs:        body.WhitelistedConfigURLs,
		WhitelistedPanelURLs:         body.WhitelistedPanelURLs,
	}

	for k, v := range body.IconPaths {
		manifest.IconPaths[emsprotocol.IconSize(k)] = v
	}
	for k, v := range body.IconURLs {
		manifest.IconURLs[emsprotocol.IconSize(k)] = v
	}

	manifest.Views.Panel.ViewerPath = body.Views.Panel.ViewerPath
	manifest.Views.Panel.Height = body.Views.Panel.Height

	manifest.Views.VideoOverlay.ViewerPath = body.Views.VideoOverlay.ViewerPath

	manifest.Views.Component.ViewerPath = body.Views.Component.ViewerPath
	manifest.Views.Component.AspectWidth = body.Views.Component.AspectWidth
	manifest.Views.Component.AspectHeight = body.Views.Component.AspectHeight
	manifest.Views.Component.Size = body.Views.Component.Size
	manifest.Views.Component.Zoom = body.Views.Component.Zoom
	manifest.Views.Component.ZoomPixels = body.Views.Component.ZoomPixels

	manifest.Views.Mobile.ViewerPath = body.Views.Mobile.ViewerPath

	manifest.Views.Config.ViewerPath = body.Views.Config.ViewerPath

	manifest.Views.LiveConfig.ViewerPath = body.Views.LiveConfig.ViewerPath

	return nil, emsClient.AddExtension(ctx, manifest, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})
}
