package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol/request"
	"code.justin.tv/extensions/orchestration/service/protocol/response"
	"code.justin.tv/foundation/twitchclient"
	emsdocs "code.justin.tv/gds/gds/extensions/ems/documents"
	"code.justin.tv/gds/gds/golibs/params"
)

// AddExtensionImageAssets - upload extension image assets (logo, taskbar icon, discovery image)
func AddExtensionImageAssets(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	var body request.AddExtensionImageAssetsFlags
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	eid := p.Get("eid")
	version := p.Get("version")

	emsClient := ems.RetrieveClient(ctx)

	params := emsdocs.AddExtensionImageAssetsFlags{
		Logo:       body.Logo,
		Taskbar:    body.Taskbar,
		Discovery:  body.Discovery,
		Screenshot: body.Screenshot,
	}

	emsResps, err := emsClient.AddExtensionImageAssets(ctx, eid, version, params, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	orchResps := response.UploaderResponses{
		UploaderResponses: map[string][]*response.UploaderResponse{},
	}

	for key, respVal := range emsResps.UploaderResponses {
		uploadRespList := make([]*response.UploaderResponse, len(respVal))
		for k, v := range respVal {
			uploadResp := &response.UploaderResponse{
				Url:      v.Url,
				UploadId: v.UploadId,
			}

			uploadRespList[k] = uploadResp
		}

		orchResps.UploaderResponses[key] = uploadRespList
	}

	return orchResps, nil
}
