package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol/request"
	"code.justin.tv/extensions/orchestration/service/protocol/response"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// AddExtensionZipAsset - upload extension zip asset
func AddExtensionZipAsset(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	var body request.AddExtensionZipAssetRequest
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	eid := p.Get("eid")
	version := p.Get("version")

	emsClient := ems.RetrieveClient(ctx)

	emsResp, err := emsClient.AddExtensionZipAsset(ctx, eid, version, body.Filename, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	orcResp := response.UploaderResponse{
		Url:      emsResp.Url,
		UploadId: emsResp.UploadId,
	}

	return orcResp, nil
}
