package api

import (
	"net/http"
)

// API is the collection of resources necessary to run the orchestrator service
type API struct {
}

// NewAPI generates a new API struct
func NewAPI() (*API, error) {
	return &API{}, nil
}

// Note: no internal orchestrator errors yet!
var knownErrors = map[error]int{}

// GetCode turns a given error into a status code
func GetCode(err error) int {
	if found, ok := knownErrors[err]; ok {
		return found
	}
	return http.StatusInternalServerError
}
