package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// DeleteExtension - soft delete a extension
func DeleteExtension(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	eid := p.Get("id")

	emsClient := ems.RetrieveClient(ctx)

	return nil, emsClient.DeleteExtension(ctx, eid, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

}
