package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// DeleteExtensionVersion - soft delete a extension version
func DeleteExtensionVersion(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	eid := p.Get("id")
	version := p.Get("version")

	emsClient := ems.RetrieveClient(ctx)

	return nil, emsClient.DeleteExtensionVersion(ctx, eid, version, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

}
