package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/extensions/orchestration/service/protocol/shared"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// DeveloperAddExtension - create or update an extension version
func DeveloperAddExtension(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	var body shared.ExtensionManifest
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	emsClient := ems.RetrieveClient(ctx)

	manifest := protocol.ToEMSExtensionManifest(&body)

	resp, err := emsClient.AddExtensionV2(ctx, *manifest, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return protocol.FromEMSExtensionManifest(resp), nil
}
