package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// DeveloperCloneExtension - duplicate an extension version
func DeveloperCloneExtension(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)

	eid := p.Get("id")
	version := p.Get("version")
	newVersion := p.Get("new_version")

	emsClient := ems.RetrieveClient(ctx)

	manifest, err := emsClient.CloneVersion(ctx, eid, version, newVersion, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return protocol.FromEMSExtensionManifest(manifest), nil
}
