package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/extensions/orchestration/service/protocol/request"
	"code.justin.tv/foundation/twitchclient"
	emsdocs "code.justin.tv/gds/gds/extensions/ems/documents"
	"code.justin.tv/gds/gds/golibs/params"
)

// DeveloperDeleteExtensionImageAssets - delete an extension's image assets
func DeveloperDeleteExtensionImageAssets(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)

	var body request.DeleteExtensionAssetsParams
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	eid := p.Get("id")
	version := p.Get("version")

	emsClient := ems.RetrieveClient(ctx)

	urls := append(body.Urls[:0:0], body.Urls...)

	deleteRequest := emsdocs.DeleteExtensionAssetsParams{
		Urls: urls,
	}

	manifest, err := emsClient.DeleteExtensionImageAssets(ctx, eid, version, deleteRequest, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return protocol.FromEMSExtensionManifest(manifest), nil
}
