package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// DeveloperGetExtensionManifest - get manifests for one version of an extension
func DeveloperGetExtensionManifest(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	eid := p.Get("id")
	version := p.Get("version")

	emsClient := ems.RetrieveClient(ctx)

	manifest, err := emsClient.GetExtensionManifest(ctx, eid, version, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return protocol.FromEMSExtensionManifest(manifest), nil

}
