package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/extensions/orchestration/service/protocol/shared"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// DeveloperGetExtensionManifests - get manifests for all versions of an extension
func DeveloperGetExtensionManifests(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	eid := p.Get("id")
	token := p.GetOptional("token")

	emsClient := ems.RetrieveClient(ctx)

	manifests, deleted, newToken, err := emsClient.GetExtensionManifests(ctx, eid, token, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	resp := shared.ExtensionManifestResponse{
		Deleted:     deleted,
		PagingToken: newToken,
	}

	for k, v := range manifests {
		resp.Manifests[k] = protocol.FromEMSExtensionManifest(v)
	}

	return resp, nil

}
