package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/extensions/orchestration/service/protocol/request"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// DeveloperTransitionExtensionState - move extensions through their lifecycle
func DeveloperTransitionExtensionState(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	var body request.StateTransition
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	eid := p.Get("id")
	version := p.Get("version")

	emsClient := ems.RetrieveClient(ctx)

	manifest, err := emsClient.TransitionExtensionStateV2(ctx, eid, version, body.State, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return protocol.FromEMSExtensionManifest(manifest), nil
}
