package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/twirputils"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/extensions/ems/documents"
	"code.justin.tv/gds/gds/golibs/params"
)

func AddCategory(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)

	var body documents.AddCategoryRequest
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	if config.RetrieveConfig(ctx).CallDiscovery {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.AddCategoryRequest{
			Category: &discovery.CategoryUpsert{
				Readonly: twirputils.WrapBoolPointer(body.Readonly),
				Visible:  twirputils.WrapBoolPointer(body.Visible),
				Type:     twirputils.WrapStringPointer(body.Type),
				SortKey:  twirputils.WrapStringPointer(body.SortKey),
				Order:    twirputils.WrapFloatPointer(body.Order),
				Slug:     twirputils.WrapStringPointer(body.Slug),
			},
		}

		cat, err := discoveryClient.AddCategory(ctx, req)
		if err != nil {
			return nil, err
		}

		doc := protocol.FromDiscoveryCategory(cat.GetCategory())

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.AddCategory(ctx, body, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
