package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/twirputils"
	"code.justin.tv/extensions/orchestration/service/api"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/extensions/ems/documents"
	"code.justin.tv/gds/gds/golibs/params"
)

func AddExtensionToCategory(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	eid := p.Get("eid")
	cid := p.Get("cid")
	language := api.GetLanguage(p)

	var body documents.AddExtensionToCategoryRequest
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	if config.RetrieveConfig(ctx).CallDiscoveryEMSAPIs {
		discoveryClient := discoman.RetrieveClient(ctx)

		startTime, err := twirputils.WrapTimePointer(body.StartTime)
		if err != nil {
			return nil, err
		}

		req := &discovery.AddExtensionToCategoryRequest{
			StartTime:   startTime,
			Order:       twirputils.WrapFloatPointer(body.Order),
			ExtensionID: eid,
			CategoryID:  cid,
			Language:    language,
		}

		resp, err := discoveryClient.AddExtensionToCategory(ctx, req)
		if err != nil {
			return nil, err
		}

		doc, err := protocol.FromDiscoveryCategoryMembership(resp.GetExtensionCategoryMembership())
		if err != nil {
			return nil, err
		}

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.AddExtensionToCategory(ctx, eid, cid, body, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
