package discoveryapi

import (
	"context"
	"strconv"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/extensions"
	"code.justin.tv/gds/gds/golibs/params"
)

func AddGameToExtension(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	gid, giderr := strconv.Atoi(p.Get("gid"))
	if giderr != nil {
		return nil, extensions.ErrInvalidGameId
	}
	eid := p.Get("eid")
	version := p.Get("version")

	if config.RetrieveConfig(ctx).CallDiscoveryEMSAPIs {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.AddGameToExtensionRequest{
			VersionID:   version,
			ExtensionID: eid,
			GameID:      int32(gid),
		}

		resp, err := discoveryClient.AddGameToExtension(ctx, req)
		if err != nil {
			return nil, err
		}

		doc := protocol.FromDiscoveryExtensionGameMembership(resp.GetExtensionGameMembership())

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.AddGameToExtension(ctx, eid, version, gid, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
