package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

func DeleteCategory(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	cid := p.Get("cid")

	if config.RetrieveConfig(ctx).CallDiscoveryEMSAPIs {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.DeleteCategoryRequest{
			CategoryID: cid,
		}

		resp, err := discoveryClient.DeleteCategory(ctx, req)
		if err != nil {
			return nil, err
		}

		doc := protocol.FromDiscoveryCategory(resp.GetCategory())

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.DeleteCategory(ctx, cid, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
