package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/gds/gds/golibs/http"
	"code.justin.tv/gds/gds/golibs/params"
)

func DeleteExtensionVersionDiscoveryDataAPICall(deleteFunc func(ctx context.Context, extensionID, version string) (*discovery.DeleteExtensionVersionDiscoveryDataResponse, error)) http.APICall {
	return http.APICall(func(ctx context.Context) (interface{}, error) {
		p := params.New(ctx)
		return deleteFunc(ctx, p.Get("id"), p.Get("version"))
	})
}

func DeleteExtensionVersionDiscoveryData(ctx context.Context, extensionID, version string) (*discovery.DeleteExtensionVersionDiscoveryDataResponse, error) {
	req := &discovery.DeleteExtensionVersionDiscoveryDataRequest{
		ExtensionID: extensionID,
		Version:     version,
	}
	return discoman.RetrieveClient(ctx).DeleteExtensionVersionDiscoveryData(ctx, req)
}
