package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

func DeleteFeaturedCarousel(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	fcid := p.Get("fcid")
	if fcid == "" {
		return nil, protocol.ErrMissingParameter
	}

	if config.RetrieveConfig(ctx).CallDiscovery {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.DeleteFeaturedCarouselRequest{
			CarouselID: fcid,
		}

		resp, err := discoveryClient.DeleteFeaturedCarousel(ctx, req)
		if err != nil {
			return nil, err
		}

		doc, err := protocol.FromDiscoveryFeaturedCarousel(resp.GetFeaturedCarousel())
		if err != nil {
			return nil, err
		}

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.DeleteFeaturedCarousel(ctx, fcid, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
