package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/api"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/extensions/ems/documents"
	"code.justin.tv/gds/gds/golibs/params"
)

func EditCategoryTranslation(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	cid := p.Get("cid")
	language := api.GetLanguage(p)

	var body documents.EditCategoryTranslationRequest
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	if config.RetrieveConfig(ctx).CallDiscovery {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.EditCategoryTranslationRequest{
			CategoryID:  cid,
			Description: body.Description,
			Language:    language,
			Name:        body.Name,
		}

		resp, err := discoveryClient.EditCategoryTranslation(ctx, req)
		if err != nil {
			return nil, err
		}

		doc := protocol.FromDiscoveryCategory(resp.GetCategory())

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.EditCategoryTranslation(ctx, cid, language, body, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
