package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/api"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

func GetCategory(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	cid := p.Get("cid")
	language := api.GetLanguage(p)

	if config.RetrieveConfig(ctx).CallDiscovery {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.GetCategoryRequest{
			CategoryID: cid,
			Language:   language,
		}

		cat, err := discoveryClient.GetCategory(ctx, req)
		if err != nil {
			return nil, err
		}

		doc := protocol.FromDiscoveryCategory(cat.GetCategory())
		if err != nil {
			return nil, err
		}

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.GetCategory(ctx, cid, language, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
