package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/api"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/extensions/ems/documents"
	"code.justin.tv/gds/gds/golibs/params"
)

func GetCategoryExtensions(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	cid := p.Get("cid")
	offset, limit, err := api.GetPagination(p)
	if err != nil {
		return nil, err
	}
	body := documents.GetCategoryExtensionsRequest{
		Offset: offset,
		Limit:  limit,
	}

	if config.RetrieveConfig(ctx).CallDiscoveryEMSAPIs {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.GetCategoryExtensionsRequest{
			Offset:     int32(offset),
			Limit:      int32(limit),
			CategoryID: cid,
		}

		resp, err := discoveryClient.GetCategoryExtensions(ctx, req)
		if err != nil {
			return nil, err
		}

		doc := protocol.FromDiscoveryCategoryExtensionsDocument(resp.GetCategoryExtensions())

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.GetCategoryExtensions(ctx, cid, body, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
