package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/gds/gds/golibs/http"
	"code.justin.tv/gds/gds/golibs/params"
)

// GetExtensionVersionDiscoveryDataAPICall converts a getter of extensino version discovery data to an APICall
func GetExtensionVersionDiscoveryDataAPICall(getFunc func(ctx context.Context, extensionID, version string) (*discovery.GetExtensionVersionDiscoveryDataResponse, error)) http.APICall {
	return http.APICall(func(ctx context.Context) (interface{}, error) {
		p := params.New(ctx)
		return getFunc(ctx, p.Get("id"), p.Get("version"))
	})
}

// GetExtensionVersionDiscoveryData gets the extension discovery data from discovery service
func GetExtensionVersionDiscoveryData(ctx context.Context, extensionID, version string) (*discovery.GetExtensionVersionDiscoveryDataResponse, error) {
	req := &discovery.GetExtensionVersionDiscoveryDataRequest{
		ExtensionID: extensionID,
		Version:     version,
	}
	return discoman.RetrieveClient(ctx).GetExtensionVersionDiscoveryData(ctx, req)
}

// GetExtensionVersionDiscoveryDataLegacy calls out to EMS to source the DiscoveryMetadata and adapts it to a discovery service response
func GetExtensionVersionDiscoveryDataLegacy(ctx context.Context, extensionID, version string) (*discovery.GetExtensionVersionDiscoveryDataResponse, error) {
	c := ems.RetrieveClient(ctx)

	metadata, err := c.GetExtensionDiscoveryData(ctx, extensionID, version, nil)
	if err != nil {
		return nil, err
	}

	return &discovery.GetExtensionVersionDiscoveryDataResponse{
		ExtensionVersionData: protocol.FromDiscoveryMetadataToExtensionVersionDiscoveryDocument(extensionID, version, metadata),
	}, nil
}
