package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/api"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

func GetFeaturedCarouselEntries(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	offset, limit, err := api.GetPagination(p)
	if err != nil {
		return nil, err
	}

	if config.RetrieveConfig(ctx).CallDiscovery {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.GetFeaturedCarouselEntriesRequest{
			Limit:  int32(limit),
			Offset: int32(offset),
		}

		resp, err := discoveryClient.GetFeaturedCarouselEntries(ctx, req)
		if err != nil {
			return nil, err
		}

		doc := protocol.FromDiscoveryFeaturedCarouselEntriesResponse(resp)

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.GetFeaturedCarouselEntries(ctx, offset, limit, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
